<?php
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;

    if (!function_exists('example_helper')) {
        function example_helper()
        {
            return 'This is an example helper function!';
        }
    }

    function root_path()
    {
        $PATH = '/home/takeme1/public_html/taxi';
        return $PATH;
    }

    function logged_in()
    {
        $TYPE = 'admin';
        if(app()->request->session()->has($TYPE) && isset(app()->request->session()->has($TYPE)['logged_in'])){
            return true;
        }else{
            if(isset($_POST['api']) && $_POST['api'] == 1){
                $ret_data = array('status' => '1', 'logged_in' => 0, 'message' => 'Login Required.', 'data' => array());
                header('Content-Type: application/json');
                echo json_encode($ret_data);
                die();
            }
            return false;
        }
    }
    
    function is_auth()
    {
        $TYPE = 'admin';
        if(app()->request->session()->has($TYPE) && isset(app()->request->session()->has($TYPE)['logged_in'])){
            if(isset($_POST['api']) && $_POST['api'] == 1){
                $ret_data = array('status' => '1', 'message' => 'Already Login.', 'data' => array());
                header('Content-Type: application/json');
                echo json_encode($ret_data);
                die();
            }else{
                return redirect()->away("/$TYPE/dashboard")->send();
            }
        }
    }
    
    function is_login()
    {
        $TYPE = 'admin';
        if(app()->request->session()->has($TYPE) && isset(app()->request->session()->has($TYPE)['logged_in'])){
    
        }else{
            if(isset($_POST['api']) && $_POST['api'] == 1){
                $ret_data = array('status' => '0', 'message' => 'Login First.', 'data' => array());
                header('Content-Type: application/json');
                echo json_encode($ret_data);
                die();
            }else{
                return redirect()->away("/$TYPE/login")->send();
            }
        }
    }

    function days($type = NULL)
    {
        $array = array(1=>"Monday", 2=>"Tuesday", 3=>"Wednesday", 4=>"Thursday", 5=>"Friday", 6=>"Saturday", 7=>"Sunday");
        if(isset($type) && $array[$type]){
            return $array[$type];
        }
        return $array;
    }

    function parcel_status($type = NULL)
    {
        $array = array(1=>"Pending", 2=>"Assigned", 3=>"Picked Up", 4=>"Delivered", 5=>"Canceled", 6=>"Initiate");
        if(isset($type) && $array[$type]){
            return $array[$type];
        }
        return $array;
    }

    function driver_parcel_status($type = NULL)
    {
        $array = array(1=>"Accepted", 2=>"Rejected", 3=>"Canceled");
        if(isset($type) && $array[$type]){
            return $array[$type];
        }
        return $array;
    }

    function payment_type($type = NULL)
    {
        $array = array(1=>"Cash", 2=>"Online");
        if(isset($type) && $array[$type]){
            return $array[$type];
        }
        return $array;
    }

    function distance_unit($type = NULL)
    {
        $array = array("miles"=>"Miles", "km"=>"KM");
        if(isset($type) && $array[$type]){
            return $array[$type];
        }
        return $array;
    }

    function weight_unit($type = NULL)
    {   
        $array = array("pound"=>"Pound", "kg"=>"KG");
        if(isset($type) && $array[$type]){
            return $array[$type];
        }
        return $array;
    }

    function fixed_percentage($type = NULL)
    {
        $array = array("1"=>"Flat", "2"=>"Percentage");
        if(isset($type) && $array[$type]){
            return $array[$type];
        }
        return $array;
    }

    function country($id = NULL)
    {
        if($id){
            $country = DB::table('country')->select("id","name")->where('status', '1')->where('id', $id)->orderBy('name')->first();
        }else{
            $country = DB::table('country')->select("id","name")->where('status', '1')->orderBy('name')->get();
        }
        return $country;
    }

    function currency($id = NULL)
    {
        if($id){
            $currency = DB::table('currency')->select("id","name")->where('status', '1')->where('id', $id)->orderBy('name')->first();
        }else{
            $currency = DB::table('currency')->select("id","name")->where('status', '1')->orderBy('name')->get();
        }
        return $currency;
    }

	if (!function_exists('apiResponse')) {
    	function apiResponse($status, $message, $data = null, $code = 200)
    	{
            
        	return response()->json([
            	'status'    => $status,
                'is_login'  => isUserAlreadyLoggedIn('user') ? 1 : 0,
                'is_logind' => isUserAlreadyLoggedIn('driver') ? 1 : 0,
            	'message'   => $message,
            	'data'      => $data
        	], $code);
    	}
	}

function currency_icon()
{
    return $icon = '$';
    
}

function generateRandomLocation($lat, $lng, $radiusInKm = 2)
{
    $radiusInDegrees = $radiusInKm / 111.32; // Convert km to degrees
    $u = mt_rand() / mt_getrandmax();
    $v = mt_rand() / mt_getrandmax();
    $w = $radiusInDegrees * sqrt($u);
    $t = 2 * pi() * $v;
    $newLat = $lat + $w * cos($t);
    $newLng = $lng + $w * sin($t) / cos(deg2rad($lat));
    $newCoor = ['lat' => $newLat, 'lng' => $newLng];
    return $newCoor;
}

function isUserAlreadyLoggedIn($type)
{
    $sessionUser = request()->session()->get($type);

    return !empty($sessionUser) &&
            isset($sessionUser['logged_in']) &&
            $sessionUser['logged_in'] === true;
}

function defaultProfilePic()
{
    return 'https://takeme1.greathub.in/taxi/assets/images/profile/profilepic.png';
}

function reasonList()
{
    $hash = [
                [
                    'id'        =>1,
                    'reason'    => 'Pesonal Issue'
                ],
                [
                    'id'        =>2,
                    'reason'    => 'Not safe to pick up'
                ],
                [
                    'id'        =>3,
                    'reason'    => 'Customer Behaviour'
                ],
                [
                    'id'        =>4,
                    'reason'    => 'Vihicle Issue'
                ],
                [
                    'id'        =>5,
                    'reason'    => 'Too any riders'
                ],
            ];
    return $hash;
}

function ride_type($id)
{
    $hash = [1 => "Delivery", 2 => "Food", 3 => "Ride"];
    return $hash[$id] ?? 'Ride';
}


function getScreenName($status)
{
        $statuses = [
            7 => 'Ridetrack',
            2 => 'Rideaccept',
            2 => 'Ridestart',
            9 => 'Ridestart',
        ];

        return $statuses[$status] ?? 'Dashboard';
}

function ScreenNameForUser($status)
{
        $statuses = [
            1 => 'Waitaccept',
            #2 => 'Parcelaccept',
            2 => 'Ridetrack',
            7 => 'Trackdelivery'
        ];

        return $statuses[$status] ?? 'Dashboard';
}

function statusName($status)
{
    $hash = [1=>'PENDING', 2=>'ASSIGNED', 3=>'PICKED_UP', 4=>'COMPLETE', 5=>'CANCELED', 6=>'INITIATE', 7=>'START_TRACK', 8=>'ON_THE_WAY', 9=>'DRIVER_ARRIVED', 10=>'IN_TRANSIT', 11=>'SCHEDULE_RIDE'];
    return $hash[$status] ?? 'NO';
}


define('DRIVER_COMMISSION_RATE', 0.10);
define('DRIVER_RATE_PER_KM', 5.00);

define('PENDING', 1); //1
define('ASSIGNED', 2); //2
define('PICKED_UP', 3);
define('DELIVERED', 4); //7
define('COMPLETE', 4);//7
define('CANCELED', 5);//
define('INITIATE', 6);
define('START_TRACK', 7); //5
define('ON_THE_WAY', 8); //3
define('DRIVER_ARRIVED', 9);//4
define('IN_TRANSIT', 10);//6
define('SCHEDULE_RIDE', 11);//11

