<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use App\Models\Category;
use App\Models\Peak_hours;

class CategoryController extends Controller
{
	public function index()
  	{
        $data = [];
        $url = url('/');
        $data['days'] = days();
        $data['TYPE'] = 'taxi/admin';
  		return view('admin.category.index',$data);
	}

    public function index_ajax_category_list()
    {
        #logged_in();
        $status_array = array(0=>"Idle",1=>"Active",2=>"Delete");
        $recordsTotal = Category::count_all();
        $data = Category::get_data_table();
        if($data)
        {
            foreach ($data as $row)
            {
                $peak_hours = DB::table('peak_hours')->select("*")->where('category_id',$row->id)->get();
                $row->peak_hours = $peak_hours;
                $row->status_label = isset($status_array[$row->status]) ? $status_array[$row->status] : 'NA';
                if($row->photo){
                    $row->photo_img = url('').'/category/'.$row->photo;
                }
            }
        }
        $output = array(
                'status'=>1,
                'message'=>'success',
                "recordsTotal" => $recordsTotal,
                "recordsFiltered" => $recordsTotal,
                "data" => $data,
                );

        return Response::json($output, 200);
    }

    public function save(Request $request)
    {
        $customMessages = [
            'name' => 'My Name is Required',
        ];

        $id = $request->id;
        $validator = Validator::make($request->all(),[
            'name' => 'required|string|unique:category'. ($id ? ",name,$id" : ''),
            'max_passenger_capacity' => 'required',
            'distance_included_in_the_base_fare' => 'required',
            'base_fare' => 'required',
            'fare_per_km_for_extra_run' => 'required',
        ], $customMessages);

        if($validator->fails())
              return $this->setValidatorError($validator,1);

        $_POST['day']           = (array)$_POST['day'];
        $_POST['start_time']    = (array)$_POST['start_time'];
        $_POST['end_time']      = (array)$_POST['end_time'];
        $_POST['increment']     = (array)$_POST['increment'];
        $day            = $_POST['day'];
        $start_time     = $_POST['start_time'];
        $end_time       = $_POST['end_time'];
        $increment      = $_POST['increment'];

        $path = root_path().'/category/';
        $photo = '';
        if($request->hasFile('photo')){
            $file = $request->file('photo');
            $photo = time() . '.' . $file->extension();
            $file->move($path, $photo);
        }
        if($request->id){
            $data =  Category::find($request->id);
        }else{
            $data = new Category;
        }
        $data->name = $request->name;
        $data->max_passenger_capacity = $request->max_passenger_capacity;
        $data->distance_included_in_the_base_fare = $request->distance_included_in_the_base_fare;
        $data->base_fare = $request->base_fare;
        $data->fare_per_km_for_extra_run = $request->fare_per_km_for_extra_run;
        $data->driver_cancellation_fee = $request->driver_cancellation_fee;
        $data->user_cancellation_fee = $request->user_cancellation_fee;
        $data->tax = $request->tax;
        if($photo){
           $data->photo = $photo;
        }
        $data->save();

        if($request->id){
            $category_id = $request->id;
            $msg = 'Updated';
            $ph = Peak_hours::where('category_id', $category_id);
            $ph->delete();

        }else{
            $category_id = $data->id;
            $msg = 'Inserted';
        }
        $peak_hours  = array();
        if($day){
            foreach($day as $index => $val){
                $day_id = $day[$index];
                $peak_hours[] = array(
                    'category_id'   => $category_id,
                    'day'           => $day[$index],
                    'start_time'    => $start_time[$index],
                    'end_time'      => $end_time[$index],
                    'increment'     => $increment[$index],
                );
                $ph = new Peak_hours;
                $ph->category_id = $category_id;
                $ph->day = $day[$index];
                $ph->start_time = $start_time[$index];
                $ph->end_time = $end_time[$index];
                $ph->increment = $increment[$index];
                $ph->save();
            }
        }

        return Response::json([
                        'status'  => true,
                        'message' => 'Category '.$msg.' Successfully',
                        ]);

    }

    public function enable(Request $request)
    {
        $id = $request->id;
        $validator = Validator::make($request->all(),[
            'id' => 'required',
        ]);

        if($validator->fails())
              return $this->setValidatorError($validator,1);

        if($request->id){
            $data =  Category::find($request->id);
        }
        $data->status = '1';
        $data->save();

        $msg = 'enabled';

        return Response::json([
                        'status'  => true,
                        'message' => 'Category '.$msg.' Successfully',
                        ]);

    }

    public function disable(Request $request)
    {
        $id = $request->id;
        $validator = Validator::make($request->all(),[
            'id' => 'required',
        ]);

        if($validator->fails())
              return $this->setValidatorError($validator,1);

        if($request->id){
            $data =  Category::find($request->id);
        }
        $data->status = '0';
        $data->save();

        $msg = 'disabled';

        return Response::json([
                        'status'  => true,
                        'message' => 'Category '.$msg.' Successfully',
                        ]);

    }
}
