<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Http\Requests\ParcelRequst;
use App\Services\ParcelService;
use Illuminate\Support\Facades\Storage;

use App\Models\Parcels;
use App\Models\Discount;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;

class ParcelController extends Controller
{

    protected $parcelService;

    public function __construct(ParcelService $parcelService)
    {
        $this->parcelService    = $parcelService;
    }    

    public function store(ParcelRequst $request)
    {
        $data = $request->validated();
        $data['user_id'] = $request->user_login['login_id'];
        $data['payment'] = '0.00';
        $data['payment_type'] = '1';
        $data['payment_received'] = '0';
        $data['commission'] = '0.00';
        $data['coupon_id'] = null; $data['discount_price'] = null;

        if($request->vehicle_data && isset($request->vehicle_data['id']))
        {
            $data['payment']    = $request->vehicle_data['estimated_price'];
            $data['final_price']= $request->vehicle_data['estimated_price'];
                
        }
        if(!empty($request->coupon)) {
            $data['coupon_id']      = $request->coupon['coupon_id'] ?? null;
            $data['discount_price'] = $request->coupon['discount_value'] ?? null;
            $data['payment']        = $request->coupon['estimated_price'];
            $data['final_price']    = $request->coupon['final_price'];
        }
        
        if(isset($data['schedule_ride']) && $data['schedule_ride']) {
            $scheduleDateRaw = $data['schedule_ride'];
            $scheduleDate = $scheduleDateRaw
                ? Carbon::createFromFormat('d-M Y H:i', $scheduleDateRaw)->format('Y-m-d H:i:s')
                : null;
            $data['schedule_ride'] = $scheduleDate;
        } 

        \Log::info('rideCreate:', $data);
        #exit; 
        $parcel = $this->parcelService->createParcel($data);
       
        return apiResponse(1, 'Parcel created successfully.', $parcel, 200); 
    }

    public function cancelParcel(ParcelRequst $request)
    {
        $login_detail= $request->login_detail;

        $validated  = $request->validated();
        $parcelId   = $validated['ride_id'];
        $reason     = $validated['reason'];
        $userId     = $request->user_login['login_id'];

        $success = $this->parcelService->cancelParcelByUser($parcelId, $userId, $reason);

        if($success)
        return apiResponse(1, 'Parcel canceled successfully.', $success, 200);

        return apiResponse(0, 'Parcel could not be canceled.', '', 400);

    }

    public function show(ParcelRequst $request, $parcel_id)
    {
        $data['user_id'] = $request->user_login['login_id'];
        $parcel = $this->parcelService->getParcel($parcel_id); 

        if($parcel)
        return apiResponse(1, 'Parcel Detail.', $parcel, 200);      
        else
        return apiResponse(0, 'Valid Parcel id required.', [], 200);        
  
    }

    public function isParcelAccept()
    {
        $parcel = $this->parcelService->isRideAccept();

        if (!$parcel) {
            return apiResponse(1, 'Driver Not Found.', $parcel, 200);
        }

        return apiResponse(1, 'Accepted.', $parcel, 200); 
    }

    public function inProcessRide(Request $request)
    {
        $userId = $request->user_login['login_id'];

        $data = $this->parcelService->inProcessRide($userId);
        if ($data) {
            return apiResponse(1, 'In Process Ride.', $data, 200);
        }

        return apiResponse('1', 'Failed to get parcel.', '', 400);
    }

    public function rideStartStatus(ParcelRequst $request)
    {
        $userId = $request->user_login['login_id'];

        $data = $request->validated();

        $data = $this->parcelService->startRideStatus($userId, $data['parcel_id']);
        if ($data) {
            return apiResponse(1, 'In Process Ride.', $data, 200);
        }

        return apiResponse('0', 'There is not ride for this request.', '', 400);
    }

    public function rideTrack(Request $request)
    {
        $userId = $request->user_login['login_id'];
        $data = $this->parcelService->rideTrack($userId);
    }

    public function rideStatus(Request $request)
    {
        $userId = $request->user_login['login_id'];
        $parcelId = $request->input('parcel_id');
        $recentCompletedRide = Parcels::with('driver')
            ->where('user_id', $userId)
            ->where('id', $parcelId)
            ->first();
        $recentCompletedRide->status_name   = statusName($recentCompletedRide->status);   
        return apiResponse(1, 'Ride Status', $recentCompletedRide, 200);
    }

    public function recentRide(Request $request)
    {
        $userId = $request->user_login['login_id'];
        $recentCompletedRide = Parcels::with('driver.category')
            ->where('user_id', $userId)
            ->where('status', COMPLETE)
            ->orderBy('id', 'DESC')
            ->first();
        if($recentCompletedRide){
            $date = Carbon::parse($recentCompletedRide->created_at);
            $recentCompletedRide->currency          = currency_icon();
            $recentCompletedRide->created_at_mdfy   =  $date->format('j-M-Y H:i');
            $recentCompletedRide->category_photo_root_url = url('').'/category/';
             
            return apiResponse(1, 'Recent Ride', $recentCompletedRide, 200);
        }else{
            return apiResponse(0, 'There is no ride.', '', 200);
        }


    }

    public function allRides(Request $request)
    {
        $user_id = $request->user_login['login_id'];
        $trips = $this->parcelService->allRides($user_id);
        if(count($trips))
        return apiResponse(1, 'All Trips.', $trips, 200);
        else
        return apiResponse(0, 'No Trips.', $trips, 200);
    }
   
    public function couponList(Request $request)
    {
        $user_id = $request->user_login['login_id'];
        $couponArr = $this->parcelService->allCoupon();
        if(count($couponArr))
        return apiResponse(1, 'Coupon List.', $couponArr, 200);
        else
        return apiResponse(0, 'There is no active coupon.', [], 200);

    } 

    public function applyCoupon(ParcelRequst $request)
    {
        $data = $request->validated();
        $data['user_id'] = $request->user_login['login_id'];
        
        $coupon = Discount::find($data['coupon_id']);
        if($coupon && $data['original_price'])
        {
            if($data['original_price'] < $coupon->min_amount) {
                return apiResponse(0, 'This coupon requires a minimum amount of '. $coupon->min_amount . '.', [], 200);
            }
            $discountType       = $coupon->type;
            $discountValue      = $coupon->amount;
            $discountMinValue   = $coupon->min_amount;
            $originalPrice      = $data['original_price'];
            $finalPrice         = $originalPrice;
            $discount_precent_amount = 0;
            if ($discountType == 'flat') {
            $discount_precent_amount = $discountValue;
            $finalPrice -= $discountValue;
            } elseif ($discountType == 'percent') {
            $discount_precent_amount = ($originalPrice * $discountValue) / 100;
            $finalPrice -= $discount_precent_amount;
            }

            $finalPrice = max(0, $finalPrice);
         
            $api_data = [];
            $api_data['coupon_id']      = $coupon->id;
            $api_data['coupon_name']    = $coupon->name;
            $api_data['discount_type']  = $discountType;
            $api_data['discount_value'] = round($discount_precent_amount);
            $api_data['original_price'] = round($originalPrice);
            $api_data['estimated_price']= round($originalPrice);
            $api_data['final_price']    = round($finalPrice);
            $api_data['currency']       = currency_icon();
       
            return apiResponse(1, 'Coupon Apply Successfully.', $api_data, 200);

        } else {
            return apiResponse(0, 'There is no ride.', [], 200); 
        } 
    }

    public function cancelReason()
    {
        return apiResponse(1, 'Reason List.', reasonList(), 200);
    }
        

}
