<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Controller;

use App\Models\Ride;
use App\Events\TaxiRequestEvent;
use Illuminate\Http\Request;

class RideController extends Controller
{
    public function createRide(Request $request)
    {
        $ride = Ride::create([
            'user_id' => 12,
            'pickup' => $request->pickup,
            'dropoff' => $request->dropoff,
            'status' => 'pending'
        ]);

        broadcast(new TaxiRequestEvent($ride))->toOthers();

        return response()->json(['message' => 'Ride requested!', 'ride' => $ride]);
    }

    public function acceptRide($rideId)
    {
        $ride = Ride::find($rideId);
        $ride->status = 'accepted';
        $ride->save();

        broadcast(new TaxiRequestEvent($ride))->toOthers();

        return response()->json(['message' => 'Ride accepted!', 'ride' => $ride]);
    }
}

