<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Parcel;
use App\Models\Drivers;

class DriverEarning extends Model
{
    use HasFactory;
    protected $table = 'driver_earnings';

    protected $fillable = [
        'driver_id',
        'parcel_id',
        'total_price',
        'driver_commission',
        'distance_covered'
    ];

    public function driver()
    {
        return $this->belongsTo(Drivers::class);
    }

    public function parcel()
    {
        return $this->belongsTo(Parcels::class);
    }
     
}
