<?php
namespace App\Services;

use App\Repositories\IncidentRepository;
use Illuminate\Support\Facades\Storage;

class IncidentService
{
    protected $repository;

    public function __construct(IncidentRepository $repository)
    {
        $this->repository = $repository;
    }

    public function saveIncident($validatedData)
    {
        // Handle photos upload
        $uploadedPhotos = [];
        foreach ($validatedData['photos'] as $photo) {
            $path = $photo->store('photo_messages', 'public'); // Save to `storage/app/public/photo_messages`
            $uploadedPhotos[] = $path;
        }

        // Save data to the repository
        $data = [
            'message' => $validatedData['message'],
            'photos' => json_encode($uploadedPhotos), // Store as JSON
        ];

        return $this->repository->storeIncident($data);
    }
}

