<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Location extends Model
{
    use HasFactory;
    protected $table = 'location';

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Accessor for the 'created_at' attribute
    public function getCreatedAtAttribute($value)
    {
        return Carbon::parse($value)->format('Y-m-d H:i:s');
    }

    // Accessor for the 'updated_at' attribute
    public function getUpdatedAtAttribute($value)
    {
        return Carbon::parse($value)->format('Y-m-d H:i:s');
    }

    public function get_data_table($client_id = NULL)
    {
        $data = Location::where('status', '1')
               ->orderBy('name')
               ->take(10)
               ->get();
        return $data;
    }
    
    public function count_all()
    {
        $count =  Location::count();
        return $count;
    }
}
