@extends('admin.layouts.main')
@section('main.container')
<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <!-- Row -->
        <div class="row">
            <!-- Column starts -->
            <div class="col-xl-12">
                <div class="card" id="accordion-five">
                    <div class="card-header flex-wrap d-flex justify-content-between px-3">
                        <div>
                            <h4 class="card-title">Discount</h4>
                            <p class="m-0 subtitle">Note: Please arrange Discount</p>
                        </div>
                        <ul class="nav nav-tabs dzm-tabs" id="myTab-4" role="tablist">
                            <li class="nav-item" role="presentation">
                                <a href="javascript:void(0)" class="btn btn-primary add_new">Add New</a>
                            </li>
                        </ul>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table id="table" class="display nowrap table" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Code</th>
                                        <th>Amount</th>
                                        <th>Type</th>
                                        <th>Min Amount</th>
                                        <th>Period</th>
                                        <th>Status</th>
                                        <th>Created</th>
                                        <th>Action</th>
                                    </tr>
                                    <tr>
                                        <td><input type="text" placeholder="Name" size="10" class="input-fw"/></td>
                                        <td><input type="text" placeholder="Code" size="10" class="input-fw"/></td>
                                        <td></td>
                                        <td><input type="text" placeholder="Type" size="10" class="input-FW"/></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Column ends -->
    </div>
</div>

<!------- MODAL ------->
<div class="modal right fade" id="myModel" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-center modal-xl" style="width:100%;">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Discount</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form role="form" id="myForm" autocomplete="off" enctype='multipart/form-data' class="parsley-validate" data-validate="parsley">
            <div class="modal-body">
                <div class="row">
                    <div class="col-12">
                        <!--This Part is removed it is only here for my ref -->
                        <div class="row">
                            <div class="col-12">
                                <div class="card mb-0">
                                    <div class="card-header p-1">
                                        <h4 class="card-title">Basic Details</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Name</label>
                                                <input type="text" class="form-control" name="name" id="name" placeholder="Name" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="code" class="form-label mb-2">Code</label>
                                                <input type="text" class="form-control" name="code" id="code" placeholder="Code" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="amount" class="form-label mb-2">Amount</label>
                                                <input type="text" class="form-control unsigned_float" name="amount" id="amount" placeholder="Amount" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <div class="basic-form">
                                                    <label for="attribute" class="form-label mb-2">Type</label>
                                                    <div class="mb-3 mb-0">
                                                        <div class="form-check d-inline-block">
                                                            <label class="form-check-label">
                                                            <input type="radio" class="form-check-input me-2" name="type" value="flat">Flat
                                                            </label>
                                                        </div>
                                                        <div class="form-check d-inline-block mx-2">
                                                            <label class="form-check-label">
                                                            <input type="radio" class="form-check-input me-2" name="type" value="percent">Percent
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

        <div class="mb-3 col-8">
        <label for="description" class="form-label mb-2">Description</label>
                                                <textarea class="form-control" name="description" id="description" placeholder="Description" data-parsley-required="true" rows="3"></textarea>
                                                </div>
                                        </div>
                                    </div>
                                    <div class="card-header p-1">
                                        <h4 class="card-title">Usage Limit</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="min_amount" class="form-label mb-2">Min Amount</label>
                                                <input type="text" class="form-control unsigned_float" id="min_amount" name="min_amount" placeholder="Min Amount" data-parsley-required="true">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-header p-1">
                                        <h4 class="card-title">Date Range</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="date" class="form-label mb-2">Date</label>
                                                <input type="text" class="form-control daterange" name="date" id="date" placeholder="Date" readonly>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary save">Save</button>
           </div>
           </form>
        </div>
    </div>
</div>


<div class="modal fade" id="detailsModal" tabindex="-1" aria-labelledby="detailsModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="detailsModalLabel">Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
      </div>
    </div>
  </div>
</div>

<script>
$(document).on('change','.select-single',function(e){
    $(this).parsley().validate();
    if ($(this).parsley().isValid()){
        $(this).find('~ .select2-container .select2-selection--single').removeAttr('style');
    }
});

$(function() {
    $('#date').daterangepicker({
      drops: 'up',
      autoUpdateInput: false,
      minDate: moment(),
      locale: {
          format: 'YYYY-MM-DD',
          cancelLabel: 'Clear'
      },
      parentEl: "#myModel",
    });
    $('#date').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD')+ ' - ' + picker.endDate.format('YYYY-MM-DD'));
    });
    $('#date').on('cancel.daterangepicker', function(ev, picker) {
        $(this).val('');
    });

/*
    $('#time').daterangepicker({
      drops: 'up',
      autoUpdateInput: false,
      datePicker: false,
      timePicker: true,
      timePicker24Hour: true,
      locale: {
          format: 'HH:mm',
          cancelLabel: 'Clear'
      },
      parentEl: "#myModel",
    });
    $('#time').on('apply.daterangepicker', function(ev, picker) {
        var startTime = $(this).data('daterangepicker').startDate.format('HH:mm');
        var endTime = $(this).data('daterangepicker').endDate.format('HH:mm');
        $(this).val(startTime+ ' - ' + endTime);
    });
    $('#time').on('cancel.daterangepicker', function(ev, picker) {
        $(this).val('');
    });
    $('#time').on('click', function(ev, picker) {
        console.log($(this).val());
        $('#time').trigger('change');
    });
*/
});

var table;
$( document ).ready(function() {
    dataTable();
});

function dataTable()
{
    var postData = {'name': 'neeraj'};
    table = $('#table').DataTable({
        pageLength:100,
        paging:true,
        select: false,
        ordering: false,
        info: true,         
        lengthChange:false ,
        language: {
            paginate: {
              next: '<i class="fa-solid fa-angle-right"></i>',
              previous: '<i class="fa-solid fa-angle-left"></i>' 
            }
        },
        "ajax": {
            "url": "/<?= $TYPE ?>/discount/index_ajax_discount_list",
            "type": "POST",
            data: postData,
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        },
        "initComplete": function(settings, json) {
            //js_switch();
        },
        "columnDefs": [ 
            {
                "className": "custom-btngroup",
                "targets": 6,
                "data": null,
                "render": function ( data, type, row ) {
                    var td = '';
                    if(row.status == 1){
                        td=`
                            <td>
                                <span class="badge light badge-success">
                                    <i class="fa fa-circle text-success me-1"></i>
                                    ${row.status_label}
                                </span>
                            </td>
                        `;
                    }else{
                        td=`
                            <td>
                                <span class="badge light badge-danger">
                                    <i class="fa fa-circle text-danger me-1"></i>
                                    ${row.status_label}
                                </span>
                            </td>
                        `;
                    }
                    return td;
                },
                "defaultContent": ''
            },
            {
                "className": "custom-btngroup",
                "targets": -1,
                "data": null,
                "render": function ( data, type, row ) {
                    var enable_disable = '';
                    if(row.status == 1){
                        enable_disable = `<a class="dropdown-item disable" href="javascript:void(0)">Idle</a>`;
                    }else{
                        enable_disable = `<a class="dropdown-item enable" href="javascript:void(0)">Active</a>`;
                    }
                    var jsonString = JSON.stringify(row);
                    var td = `
                           <td>
                               <div class="dropdown ms-auto text-end c-pointer">
                                   <div class="btn-link" data-bs-toggle="dropdown" aria-expanded="false">
                                       <svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                           <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                               <rect x="0" y="0" width="24" height="24"></rect>
                                               <circle fill="#000000" cx="5" cy="12" r="2"></circle>
                                               <circle fill="#000000" cx="12" cy="12" r="2"></circle>
                                               <circle fill="#000000" cx="19" cy="12" r="2"></circle>
                                           </g>
                                       </svg>
                                   </div>
                                   <div class="dropdown-menu dropdown-menu-end" style="" data-object='${jsonString}'>
                                       ${enable_disable}
                                       <a class="dropdown-item edit" href="javascript:void(0)">Edit</a>
                                       <a class="dropdown-item view-details" href="javascript:void(0)">View</a>
                                   </div>
                               </div>
                           </td>
                    `;
                    return td;
                },
                "defaultContent": ''
            },
        ],
        "columns": [
           {data: "name"},
           {data: "code"},
           {data: "amount"},
           {data: "type"},
           {data: "min_amount", visible: false },
           {data: "date", visible: false },
           {data: "status", visible: false },
           {data: "created_at", visible: false },
           {data: "id"},
        ]
    });

   $("#table thead input").on('keyup change', function(e) {
        if (e.keyCode == 13 || e.keyCode == undefined || this.value == '') {
            table
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();
        }
   });
   $('#table_filter').hide();
}

const modals = {
  details: {
    title: "Details",
    fields: {
      name: "Name",
      code: "Code",
      amount: "Amount",
      type: "Type",
      min_amount: "Min Amount",
      date: "Period Date",
      status: "Status",
      created_at: "Created At",
    },
  },
}

$(document).on('click','.disable',function(e){
    e.preventDefault();
    var row = $(this).parent().data('object');
    var id = row.id;
    var postData = new FormData()
    postData.append('api', '1');
    postData.append('id', id);
    $.ajax({
        type: 'POST',
        url:  "/<?= $TYPE ?>/discount/disable",
        data: postData,
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        contentType: false,
        cache: false,
        processData:false,
        beforeSend: function() {
             //$('.as_loader').addClass('show');
        },
        success: function(response){
            if(response.status == '1') {
                table.ajax.reload();
                $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
            }else{
                $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
            }
            //$('.as_loader').removeClass('show');
        },
        error: function (error) {
            //$('.as_loader').removeClass('show');
        }
    });
});

$(document).on('click','.enable',function(e){
    e.preventDefault();
    var row = $(this).parent().data('object');
    var id = row.id;
    var postData = new FormData()
    postData.append('api', '1');
    postData.append('id', id);
    $.ajax({
        type: 'POST',
        url:  "/<?= $TYPE ?>/discount/enable",
        data: postData,
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        contentType: false,
        cache: false,
        processData:false,
        beforeSend: function() {
             //$('.as_loader').addClass('show');
        },
        success: function(response){
            if(response.status == '1') {
                table.ajax.reload();
                $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
            }else{
                $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
            }
            //$('.as_loader').removeClass('show');
        },
        error: function (error) {
            //$('.as_loader').removeClass('show');
        }
    });
});

$(document).on('click','.add_new',function(e){
    e.preventDefault();
    $('.parsley-validate').parsley().destroy(); 
    $('#myForm').find('input[name="id"]').remove();
    $('#myForm')[0].reset();
    $('#myForm input[type="radio"]').prop('checked', false);
    $('#myForm input[type="checkbox"]').prop('checked', false);
    $('#date').val('');
    $('#date').data('daterangepicker').setStartDate(moment());
    $('#date').data('daterangepicker').setEndDate(moment());
    $('#myModel').modal('toggle');
});

$(document).on('click','.edit',function(e){
    e.preventDefault();
    $('.parsley-validate').parsley().destroy(); 
    $('#myForm').find('input[name="id"]').remove();

    var row = $(this).parent().data('object');
    var id = row.id;
    fillForm(row);
    var date_str = $('#date').val();
    if(date_str){
        var myArray = date_str.split(" - ");
        $('#date').data('daterangepicker').setStartDate(myArray[0]);
        $('#date').data('daterangepicker').setEndDate(myArray[1]);
    }
    var hiddenInput = $('<input>').attr({
      type: 'hidden',
      name: 'id',
      id: 'id',
      value: id
    });
    $('#myForm').append(hiddenInput);
    $('#myModel').modal('toggle');
});

$(document).on('click','.save',function(e){
    e.preventDefault();
    $('.parsley-validate').parsley().validate();
    if ($('.parsley-validate').parsley().isValid()){
        var postData = new FormData()
        postData = getFormValues(postData);
        $.ajax({
            type: 'POST',
            url:  "/<?= $TYPE ?>/discount/save",
            data: postData,
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            dataTyte: 'json',
            enctype: 'multipart/form-data',
            contentType: false,
            cache: false,
            processData:false,
            beforeSend: function() {
                 //$('.as_loader').addClass('show');
            },
            success: function(response){
                if(response.status == '1') {
                    table.ajax.reload();
                    $('#myModel').modal('toggle');
                    $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
                }else{
                    $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
                }
                //$('.as_loader').removeClass('show');
            },
            error: function (error) {
                //$('.as_loader').removeClass('show');
            }
        });
    }
});
</script>
@endsection
