<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\Api\Driver\AuthController;
use App\Http\Controllers\Api\CustomerController;
use App\Http\Controllers\Api\Driver\Profile;
use App\Http\Controllers\Api\Driver\BankDetailController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('/send-otp', [AuthController::class, 'sendOtp']);
Route::post('/verify-otp', [AuthController::class, 'verifyOtp']);

Route::middleware('auth.custom')->get('/customer-info', [CustomerController::class, 'getCustomerInfo']);

Route::get('/customer-info', [CustomerController::class, 'getCustomerInfo']);

///////////////////////

Route::post('/send-otp', [AuthController::class, 'sendOtp']);
Route::post('/verify-otp', [AuthController::class, 'verifyOtp']);

Route::middleware('auth.custom')->post('/update-profile', [Profile::class, 'updateProfile']);

Route::middleware('auth.custom')->post('/upload', [Profile::class, 'upload']);
Route::middleware('auth.custom')->post('/updatec', [Profile::class, 'updatec']);

Route::middleware('auth.custom')->post('/bank-details', [BankDetailController::class, 'store']);

///////////////////////
