<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use App\Models\Admin;

class AuthController extends Controller
{
	public function index()
  	{
        $data = [];
        $url = url('/');
        $data['days'] = days();
        $data['TYPE'] = 'taxi/admin';
  		return view('admin.auth.login',$data);
	}

	public function login(Request $request)
  	{
        if($request->method() == 'GET'){ 
           # is_auth();
            $data = [];
            $url = url('/');
            $data['days'] = days();
            $data['TYPE'] = 'taxi/admin';
            return view('admin.auth.login',$data);
        }else{
            $customMessages = [
                'mobile' => 'Mobile is Required',
            ];

            $validator = Validator::make($request->all(),[
                    'mobile' => 'required',
                    'password' => 'required',
            ], $customMessages);

            if($validator->fails())
                return $this->setValidatorError($validator,1);

            $mobile = $request->mobile;
            $password = $request->password;
            $password = md5($password);
            $admin =  Admin::where('mobile', $mobile)->where('password', $password)->first();
            if($admin){
                 $details = array(
                                'mobile'        => $admin->mobile,
                                'email'         => $admin->email,
                                'name'          => $admin->fname,
                                'login_id'      => $admin->id,
                                'logged_in'     => TRUE
                         );
                $request->session()->put('admin', $details);
                return Response::json([
                        'status'  => true,
                        'message' => 'Login Successfully',
                        ]);
            }else{
                return Response::json([
                        'status'  => false,
                        'message' => 'Invalid Credentials',
                        ]);
            }
        }
	}

    public function logout(Request $request)
    {
        $request->session()->forget('admin');
        $request->session()->flush();
        return redirect('/admin/login');
        /*if(is_api()){
            $ret_data = array('status'  => 1, 'message' => 'Sucessfully logout.', 'data' => array());
            header('Content-Type: application/json');
            echo json_encode($ret_data);
            die();
        }else{
            redirect("$this->TYPE/auth/login");
        }*/
    }

}
