<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use App\Models\Package;
use App\Models\Trip;

class TripController extends Controller
{
	public function index()
  	{
        $data = [];
        $url = url('/');
        $data['weight_unit'] = weight_unit();
        $data['TYPE'] = 'taxi/admin';
  		return view('admin.trip.index',$data);
	}

    public function index_ajax_trip_list()
    {
        #logged_in();
        $payment_array = payment_type();
        $status_array = array(0=>"Idle",1=>"Active",2=>"Delete");
        $data = Trip::get_data_table();
        $recordsTotal = count($data);
        if($data)
        {
            foreach ($data as $row)
            {
                $row->status_label = isset($status_array[$row->status]) ? $status_array[$row->status] : 'NA';
                $row->driver = $row->drivers_name.'<br>'.$row->drivers_mobile.'<br>'.$row->drivers_email;
                $row->users  = $row->users_name.'<br>'.$row->users_mobile.'<br>'.$row->users_email;
                $row->pickup = $row->pickup_name.'<br>'.$row->pickup_mobile.'<br>'.$row->pickup_address;
                $row->delivery = $row->delivery_name.'<br>'.$row->delivery_mobile.'<br>'.$row->delivery_address;
                $row->trip = $row->pickup_time.'<br>'.$row->delivery_time;
                $row->pay_mode = isset($payment_array[$row->payment_type]) ? $payment_array[$row->payment_type] : 'NA';
            }
        }
        $output = array(
                'status'=>1,
                'message'=>'success',
                "recordsTotal" => $recordsTotal,
                "recordsFiltered" => $recordsTotal,
                "data" => $data,
                );

        return Response::json($output, 200);
    }

    public function save(Request $request)
    {
        $customMessages = [
            'name' => 'My Name is Required',
        ];

        $id = $request->id;
        $validator = Validator::make($request->all(),[
            'name' => 'required',
        ], $customMessages);

        if($validator->fails())
              return $this->setValidatorError($validator,1);

        $path = root_path().'/package/';
        $photo = '';
        if($request->hasFile('photo')){
            $file = $request->file('photo');
            $photo = time() . '.' . $file->extension();
            $file->move($path, $photo);
        }
        if($request->id){
            $data =  Package::find($request->id);
        }else{
            $data = new Package;
        }
        $data->name = $request->name;
        $data->weight_unit = $request->weight_unit;
        $data->weight_included_in_the_base_fare = $request->weight_included_in_the_base_fare;
        $data->base_fare = $request->base_fare;
        $data->fare_per_for_extra_weight = $request->fare_per_for_extra_weight;
        if($photo){
           $data->photo = $photo;
        }
        $data->save();

        if($request->id){
            $package_id = $request->id;
            $msg = 'Updated';
        }else{
            $package_id = $data->id;
            $msg = 'Inserted';
        }

        return Response::json([
                        'status'  => true,
                        'message' => 'Package '.$msg.' Successfully',
                        ]);

    }
}
