<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Category;

class VehicleController extends Controller
{

    

    public function getVehicleOptions(Request $request)
    {
        $errorResponse = $this->error_msg($request);
        if($errorResponse){
            return $errorResponse;
        }
                
        

    $pickupLat = $request->pickup_latitude;
    $pickupLng = $request->pickup_longitude;
    $dropLat = $request->delivery_latitude;
    $dropLng = $request->delivery_longitude;

    // Calculate distance using Haversine formula
    $earthRadius = 6371; // in km
    $latDiff = deg2rad($dropLat - $pickupLat);
    $lngDiff = deg2rad($dropLng - $pickupLng);

    $a = sin($latDiff/2) * sin($latDiff/2) +
         cos(deg2rad($pickupLat)) * cos(deg2rad($dropLat)) *
         sin($lngDiff/2) * sin($lngDiff/2);
    $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
    $distance = $earthRadius * $c;

    // Approximate time (in minutes)
    $averageSpeed = 30; // km/h
    $time = ceil(($distance / $averageSpeed) * 60);
    
    $query = Category::where('status', '1');
    if(isset($request->parcel_type) && ($request->parcel_type == 1 || $request->parcel_type == 2)) {
        $query->where('id', 1);
    }else {
        $query->where('id', '!=', 1);
    }

    if(isset($request->id) && $request->id)
    {
        $query->where('id', $request->id);
    }

    $vehicles = $query->get();

    $options = collect($vehicles)->map(function ($vehicle) use ($distance, $time) {
        $price = $vehicle['base_fare'] + ($vehicle['fare_per_km_for_extra_run'] * $distance);
        return [
            'id' => $vehicle['id'],
            'type' => $vehicle['name'],
            'estimated_time' => $time . ' mins',
            'estimated_price' => round($price),
            'distance'=> number_format($distance, 2),
            'currency'=> currency_icon(),
            'photo'=> url('').'/category/'.$vehicle['photo']
        ];
    });

    
    return apiResponse(1, 'Vehicle Information', $options, 200); 
    }

    function error_msg($request)
    {
        try {
        $request->validate([
                'pickup_latitude'   => 'required|numeric',
                'pickup_longitude'  => 'required|numeric',
                'delivery_latitude'     => 'required|numeric',
                'delivery_longitude'    => 'required|numeric',
        ], [
        'pickup_latitude.required' => 'Pickup latitude is missing!',
        'pickup_longitude.required' => 'Pickup longitude is missing!',
        'delivery_latitude.required' => 'Drop latitude is missing!',
        'delivery_longitude.required' => 'Drop longitude is missing!',
        ]);
        } catch (\Illuminate\Validation\ValidationException\ValidationException $e) {
            return apiResponse(0, 'Validation errors.', $e->errors(), 422);
        }
        
     
    }
  
}

