<?php
namespace App\Http\Controllers\Api\Driver;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Drivers;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
use Tymon\JWTAuth\Facades\JWTAuth;

class AuthController extends Controller
{
    public function sendOtp(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'mobile' => 'required|digits:10',
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()], 422);
        }

        $mobile = $request->mobile;
        $otp = rand(1000, 9999);

        Drivers::updateOrCreate(
            ['mobile' => $mobile],
            [
                'otp' => $otp,
                'otp_expires_at' => Carbon::now()->addMinutes(10)
            ]
        );

        $api_data = [];
        $api_data['otp'] = $otp;

        return response()->json([
            'message'   => 'OTP sent successfully. It is valid for 10 minutes..',
            'data'      => $api_data
        ], 200);
    }

    public function verifyOtp(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'mobile' => 'required|digits:10',
            'otp' => 'required|digits:4',
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()], 422);
        }

        $driver = Drivers::where('mobile', $request->mobile)
                            ->where('otp', $request->otp)
                            ->where('otp_expires_at', '>', Carbon::now())
                            ->first();

        if (!$driver) {
            return response()->json(['error' => 'Invalid OTP or OTP has expired.'], 400);
        }

        // Generate JWT token
        $token = JWTAuth::fromUser($driver);

        // Clear the used OTP
        $driver->update(['otp' => null, 'otp_expires_at' => null]);

        return response()->json([
            'token' => $token,
            'mobile' => $driver->mobile
        ], 200);
    }
}
