<?php

namespace App\Services;

use App\Repositories\BankDetailRepository;

class BankDetailService
{
    protected $repository;

    public function __construct(BankDetailRepository $repository)
    {
        $this->repository = $repository;
    }

    public function saveBankDetails(array $data)
    {
        return $this->repository->create($data);
    }

    public function updateBankDetails($id, array $data)
    {
        $bankDetail = $this->repository->find($id);
        return $this->repository->update($bankDetail, $data);
    }

}
