<?php

namespace App\Services;

use App\Models\Drivers;

use Illuminate\Http\UploadedFile;

use App\Repositories\DriverRepository;


class UploadDocService
{
    protected $driverRepository;

    public function __construct(DriverRepository $driverRepository)
    {
        $this->driverRepository = $driverRepository;
    }

    public function store($file, $path)
    {
        return $file->store($path, 'public');
    }

    public function getDriverInfo($driver)
    {
        return $this->driverRepository->find($driver['login_id']);
    }

    public function updateDriver($driver, array $data)
    {
        $driver = Drivers::find($driver['login_id']);   

        if (isset($data['vehicle_photos'])) {
            $photos = [];
            foreach ($data['vehicle_photos'] as $photo) {
                $path = $photo->store('vehicle_photos/' . $driver->id, 'public');
                $photos[] = $path;
            }
            $data['vehicle_photo'] = json_encode($photos);
        }
        return $this->driverRepository->update($driver, $data);
    }

    public function calculateAndStoreEarnings(int $driverId, int $parcelId, float $distanceCovered)
    {
        $totalPrice = $this->calculateTotalPrice($distanceCovered);
        $driverCommission = $this->calculateDriverCommission($totalPrice);

        return $this->driverRepository->storeDriverEarnings($driverId, $parcelId, $totalPrice, $driverCommission, $distanceCovered);
    }

    protected function calculateTotalPrice(float $distanceCovered): float
    {
        return ($distanceCovered * DRIVER_RATE_PER_KM);
    }

    protected function calculateDriverCommission(float $totalPrice): float
    {
        return ($totalPrice * DRIVER_COMMISSION_RATE);
    }

    public function earning($driverId)
    {
        return $this->driverRepository->earning($driverId);
    }

    public function updateTermsLegal($driverId, $status, $updateType)
    {
        return $this->driverRepository->updateTermsLegal($driverId, $status, $updateType);
    }
   
    public function checkAndUpdateProfileCompleteStatus($driverId)
    {
        $isComplete = $this->driverRepository->isProfileComplete($driverId);

        return $this->driverRepository->updateProfileCompleteStatus($driverId, $isComplete);
    } 
        
}
