<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddAddressesAndDiscountPriceToParcelsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('parcels', function (Blueprint $table) {
            $table->text('pickup_complete_address')->nullable()->after('pickup_longitude');
            $table->text('delivery_complete_address')->nullable()->after('delivery_longitude');
            $table->decimal('discount_price', 10, 2)->nullable()->after('coupon_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('parcels', function (Blueprint $table) {
            $table->dropColumn(['pickup_complete_address','delivery_complete_address','discount_price']);
        });
    }
}
