@extends('admin.layouts.main')
@section('main.container')
<style>
    .overlay-container {
        position: relative;
        display: inline-block;
    }

    .overlay-container img.overlay-image {
        display: none;
        position: absolute;
        top: 0;
        left: 0;
        z-index: 10;
        width: 200px; /* Adjust the width as needed */
        height: auto;
    }

    .overlay-container:hover img.overlay-image {
        display: block;
    }
</style>
<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <!-- Row -->
        <div class="row">
            <!-- Column starts -->
            <div class="col-xl-12">
                <div class="card" id="accordion-five">
                    <div class="card-header flex-wrap d-flex justify-content-between px-3">
                        <div>
                            <h4 class="card-title">Driver</h4>
                            <p class="m-0 subtitle">Note: Please arrange Driver</p>
                        </div>
                        <ul class="nav nav-tabs dzm-tabs" id="myTab-4" role="tablist">
                            <li class="nav-item" role="presentation">
                                <a href="javascript:void(0)" class="btn btn-primary add_new">Add New</a>
                            </li>
                        </ul>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table id="table" class="display table" style="min-width: 845px">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Mobile</th>
                                        <th>Email</th>
                                        <th>Verified</th>
                                        <th>Available</th>
                                        <th>Rating</th>
                                        <th>Wallet Balance</th>
                                        <th>Status</th>
                                        <th>Created</th>
                                        <th>Action</th>
                                    </tr>
                                    <tr>
                                        <td><input type="text" placeholder="Name" size="10" class="input-FW"/></td>
                                        <td><input type="text" placeholder="Mobile" size="10" class="input-FW"/></td>
                                        <td><input type="text" placeholder="Email" size="10" class="input-fw"/></td>
                                        <td><input type="text" placeholder="Verified" size="10" class="input-fw"/></td>
                                        <td><input type="text" placeholder="Available" size="10" class="input-fw"/></td>
                                        <td></td>
                                        <td></td>
                                        <td><input type="text" placeholder="Status" size="10" class="input-fw"/></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Column ends -->
    </div>
</div>

<!------- MODAL ------->
<div class="modal right fade" id="myModel" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-center modal-xl" style="width:100%;">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Driver</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form role="form" id="myForm" autocomplete="off" enctype='multipart/form-data' class="parsley-validate" data-validate="parsley">
            <div class="modal-body">
                <div class="row">
                    <div class="col-12">
                        <!--This Part is removed it is only here for my ref -->
                        <div class="row">
                            <div class="col-12">
                                <div class="card mb-0">
                                    <div class="card-header p-1">
                                        <h4 class="card-title">General Info</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="fname" class="form-label mb-2">Name</label>
                                                <input type="text" class="form-control" id="name" name="name" placeholder="Name">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="gender" class="form-label mb-2">Gender</label>
                                                <select class="select-single form-control wide" name="gender" data-placeholder="Gender" style="width:200px;" data-parsley-required="true" data-parsley-errors-container="#gender_error">
                                                    <option></option>                                                       
                                                    <option value="male">Male</option>
                                                    <option value="female">Female</option>
                                                    <option value="other">Other</option>
                                                </select>
                                                <div id="gender_error"></div>
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Mobile</label>
                                                <input type="text" class="form-control numeric" id="mobile" name="mobile" placeholder="Mobile" data-parsley-required="true" data-parsley-type="digits" maxlength="10" data-parsley-length="[10, 10]">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Email</label>
                                                <input type="text" class="form-control" id="email" name="email" placeholder="Email" data-parsley-required="true" data-parsley-type="email">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="availability" class="form-label mb-2">Availability</label>
                                                <select class="select-single form-control wide" name="availability" data-placeholder="availability" style="width:200px;" data-parsley-required="true" data-parsley-errors-container="#availability_error">
                                                    <option></option>
                                                    <option value="0">Unavailable</option>
                                                    <option value="1">Available</option>
                                                </select>
                                                <div id="availability_error"></div>
                                            </div>
                                            <div class="mb-3 col-12">
                                                <label for="address" class="form-label mb-2">Address</label>
                                                <textarea class="form-control" id="address" name="address" placeholder="Address" data-parsley-required="true" rows="4" cols="170"></textarea>                                                
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="profile_photo" class="form-label">Profile Photo</label>
                                                <input class="form-control form-control-sm file_upload" name="profile_photo" id="profile_photo" type="file">
                                                <a href="javascript:void(0);" id="profile_img" download>Download</a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-header p-1">
                                        <h4 class="card-title">Vehicle Info</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="category" class="form-label mb-2">Category</label>                                                                <select class="select-single form-control wide" name="category" data-placeholder="Category" style="width:200px;" data-parsley-required="true" data-parsley-errors-container="#category_error">
                                                    <option></option>
                                                    <?php if($category){ foreach($category as $cntry){ ?>
                                                    <option value="<?= $cntry->id ?>"><?= $cntry->name ?></option>
                                                    <?php }} ?>
                                                </select>
                                                <div id="category_error"></div>
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="location" class="form-label mb-2">Location</label>
                                                <select class="select-single form-control wide" name="location" data-placeholder="Location" style="width:200px;" data-parsley-required="true" data-parsley-errors-container="#location_error">
                                                    <option></option>
                                                    <?php if($location){ foreach($location as $cntry){ ?>                                                                         <option value="<?= $cntry->id ?>"><?= $cntry->name ?></option>
                                                    <?php }} ?>
                                                </select>
                                                <div id="location_error"></div>
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="model" class="form-label mb-2">Model</label>
                                                <input type="text" class="form-control" id="model" name="model" placeholder="model" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="brand" class="form-label mb-2">Brand</label>
                                                <input type="text" class="form-control" id="brand" name="brand" placeholder="Brand" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="year_of_manufacture" class="form-label mb-2">Year Of Manufacture</label>
                                                <input type="text" class="form-control numeric" id="year_of_manufacture" name="year_of_manufacture" placeholder="Year Of Manufacture" data-parsley-required="true" data-parsley-type="digits" maxlength="4" data-parsley-length="[4, 4]">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="registration_number" class="form-label mb-2">Registration Number</label>
                                                <input type="text" class="form-control" id="registration_number" name="registration_number" placeholder="Registration Number" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="vehicle_photo" class="form-label">Vehicle Photo</label>
                                                <input class="form-control form-control-sm file_upload" name="vehicle_photo" id="vehicle_photo" type="file" multiple>
                                                <span id="vehicle_photo_img"></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-header p-1">
                                        <h4 class="card-title">Documents</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="adhar" class="form-label">Identity Proff</label>
                                                <input class="form-control form-control-sm file_upload" name="adhar" id="adhar" type="file">
                                                <a href="javascript:void(0);" id="adhar_img" download>Download</a>
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="vehicle_insurance" class="form-label">Vehicle Insurance</label>
                                                <input class="form-control form-control-sm file_upload" name="vehicle_insurance" id="vehicle_insurance" type="file">
                                                <a href="javascript:void(0);" id="vehicle_insurance_img" download>Download</a>
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="driving_licence" class="form-label">Driving Licence</label>
                                                <input class="form-control form-control-sm file_upload" name="driving_licence" type="file" multiple>
                                                <span id="driving_licence_img"></span>
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="registration_certificate" class="form-label">Registration Certificate</label>
                                                <input class="form-control form-control-sm file_upload" name="registration_certificate" id="registration_certificate" type="file">
                                                <a href="javascript:void(0);" id="registration_certificate_img" download>Download</a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-header p-1">
                                        <h4 class="card-title">Commission</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="commission" class="form-label mb-2">Commission %</label>
                                                <input type="text" class="form-control unsigned_float" id="commission" name="commission" data-parsley-required="true" placeholder="Commission">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="stauts" class="form-label mb-2">Verified</label>
                                                <select class="select-single form-control wide" name="verified" data-placeholder="Verified" style="width:200px;" data-parsley-required="true" data-parsley-errors-container="#verified_error">
                                                    <option></option>
                                                    <option value="0">Pending</option>
                                                    <option value="1">Verified</option>
                                                    <option value="2">Rejected</option>
                                                </select>
                                                <div id="verified_error"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary save">Save</button>
           </div>
           </form>
        </div>
    </div>
</div>
<script>
$(document).on('change','.select-single',function(e){
    $(this).parsley().validate();
    if ($(this).parsley().isValid()){
        $(this).find('~ .select2-container .select2-selection--single').removeAttr('style');
    }
});

$(function(){
    $('.select-single').select2({
        dropdownParent: $('#myModel')
    });
});

var table;
$( document ).ready(function() {
    dataTable();
});

function dataTable()
{
    var postData = {'name': 'neeraj'};
    table = $('#table').DataTable({
        pageLength:100,
        paging:true,
        select: false,
        ordering: false,
        info: true,         
        lengthChange:false ,
        language: {
            paginate: {
              next: '<i class="fa-solid fa-angle-right"></i>',
              previous: '<i class="fa-solid fa-angle-left"></i>' 
            }
        },
        "ajax": {
            "url": "/<?= $TYPE ?>/driver/index_ajax_driver_list",
            "type": "POST",
            data: postData,
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        },
        "initComplete": function(settings, json) {
            //js_switch();
        },
        "columnDefs": [ 
            {
                "className": "custom-btngroup",
                "targets": 3,
                "data": null,
                "render": function ( data, type, row ) {
                    var td = '';
                    if(row.verified == 1){
                        td=`
                            <td>
                                <span class="badge light badge-success">
                                    <i class="fa fa-circle text-success me-1"></i>
                                    ${row.verified_label}
                                </span>
                            </td>
                        `;
                    }else{
                        td=`
                            <td>
                                <span class="badge light badge-danger">
                                    <i class="fa fa-circle text-danger me-1"></i>
                                    ${row.verified_label}
                                </span>
                            </td>
                        `;
                    }
                    return td;
                },
                "defaultContent": ''
            },
            {
                "className": "custom-btngroup",
                "targets": 4,
                "data": null,
                "render": function ( data, type, row ) {
                    var td = '';
                    if(row.availability == 1){
                        td=`
                            <td>
                                <span class="badge light badge-success">
                                    <i class="fa fa-circle text-success me-1"></i>
                                    ${row.availability_label}
                                </span>
                            </td>
                        `;
                    }else{
                        td=`
                            <td>
                                <span class="badge light badge-danger">
                                    <i class="fa fa-circle text-danger me-1"></i>
                                    ${row.availability_label}
                                </span>
                            </td>
                        `;
                    }
                    return td;
                },
                "defaultContent": ''
            },
            {
                "className": "custom-btngroup",
                "targets": 7,
                "data": null,
                "render": function ( data, type, row ) {
                    var td = '';
                    if(row.status == 1){
                        td=`
                            <td>
                                <span class="badge light badge-success">
                                    <i class="fa fa-circle text-success me-1"></i>
                                    ${row.status_label}
                                </span>
                            </td>
                        `;
                    }else{
                        td=`
                            <td>
                                <span class="badge light badge-danger">
                                    <i class="fa fa-circle text-danger me-1"></i>
                                    ${row.status_label}
                                </span>
                            </td>
                        `;
                    }
                    return td;
                },
                "defaultContent": ''
            },
            {
                "className": "custom-btngroup",
                "targets": -1,
                "data": null,
                "render": function ( data, type, row ) {
                    var enable_disable = '';
                    if(row.status == 1){
                        enable_disable = `<a class="dropdown-item disable" href="javascript:void(0)">Idle</a>`;
                    }else{
                        enable_disable = `<a class="dropdown-item enable" href="javascript:void(0)">Active</a>`;
                    }
                    var jsonString = JSON.stringify(row);
                    var td = `
                           <td>
                               <div class="dropdown ms-auto text-end c-pointer">
                                   <div class="btn-link" data-bs-toggle="dropdown" aria-expanded="false">
                                       <svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                           <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                               <rect x="0" y="0" width="24" height="24"></rect>
                                               <circle fill="#000000" cx="5" cy="12" r="2"></circle>
                                               <circle fill="#000000" cx="12" cy="12" r="2"></circle>
                                               <circle fill="#000000" cx="19" cy="12" r="2"></circle>
                                           </g>
                                       </svg>
                                   </div>
                                   <div class="dropdown-menu dropdown-menu-end" style="" data-object='${jsonString}'>
                                       ${enable_disable}
                                       <a class="dropdown-item edit" href="javascript:void(0)">Edit</a>
                                       <a class="dropdown-item view-details" href="javascript:void(0)">View</a>
                                   </div>
                               </div>
                           </td>
                    `;
                    return td;
                },
                "defaultContent": ''
            },
        ],
        "columns": [
           {data: "name"},
           {data: "mobile"},
           {data: "email"},
           {data: "verified", visible: false},
           {data: "availability", visible: false},
           {data: "rating", visible: false},
           {data: "wallet_balance", visible: false},
           {data: "status", visible: false},
           {data: "created_at", visible: false},
           {data: "id"},
        ]
    });

   $("#table thead input").on('keyup change', function(e) {
        if (e.keyCode == 13 || e.keyCode == undefined || this.value == '') {
            table
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();
        }
   });
   $('#table_filter').hide();
}

const modals = {
  details: {
    title: "Details",
    fields: {
      name: "Name",
      mobile: "Mobile",
        email: "Email",
      verified: "Verified",
      availability: "Availability",
      rating: "Rating",
      wallet_balance: "Wallet Balance",
      status: "Status",
        created_at: "Created At"
    },
  },
}


$(document).on('click','.disable',function(e){
    e.preventDefault();
    var row = $(this).parent().data('object');
    var id = row.id;
    var postData = new FormData()
    postData.append('api', '1');
    postData.append('id', id);
    $.ajax({
        type: 'POST',
        url:  "/<?= $TYPE ?>/driver/disable",
        data: postData,
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        contentType: false,
        cache: false,
        processData:false,
        beforeSend: function() {
             //$('.as_loader').addClass('show');
        },
        success: function(response){
            if(response.status == '1') {
                table.ajax.reload();
                $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
            }else{
                $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
            }
            //$('.as_loader').removeClass('show');
        },
        error: function (error) {
            //$('.as_loader').removeClass('show');
        }
    });
});

$(document).on('click','.enable',function(e){
    e.preventDefault();
    var row = $(this).parent().data('object');
    var id = row.id;
    var postData = new FormData()
    postData.append('api', '1');
    postData.append('id', id);
    $.ajax({
        type: 'POST',
        url:  "/<?= $TYPE ?>/driver/enable",
        data: postData,
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        contentType: false,
        cache: false,
        processData:false,
        beforeSend: function() {
             //$('.as_loader').addClass('show');
        },
        success: function(response){
            if(response.status == '1') {
                table.ajax.reload();
                $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
            }else{
                $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
            }
            //$('.as_loader').removeClass('show');
        },
        error: function (error) {
            //$('.as_loader').removeClass('show');
        }
    });
});

$(document).on('click','.add_new',function(e){
    e.preventDefault();
    $('.parsley-validate').parsley().destroy(); 
    $('.select2-selection--single').removeAttr('style');
    $('#myForm').find('input[name="id"]').remove();
    $('#myForm')[0].reset();
    $('.overlay-container').hide();
    $(".file_upload").val("");
    $('.select-single').trigger('change.select2');
    $('#driving_licence_img,#vehicle_photo_img').html('');
    $('#profile_img,#adhar_img,#registration_certificate_img,#vehicle_insurance_img').hide();
    $('#myModel').modal('toggle');
});

$(document).on('click','.edit',function(e){
    e.preventDefault();
    $('.parsley-validate').parsley().destroy(); 
    $('#myForm').find('input[name="id"]').remove();
    $(".file_upload").val("");
    var row = $(this).parent().data('object');
    var id = row.id;
    fillForm(row);

    $('#profile_img').hide();
    if(row.profile_img){
        $('#profile_img').attr('href',row.profile_img).show();
    }
    $('#adhar_img').hide();
    if(row.adhar_img){
        $('#adhar_img').attr('href',row.adhar_img).show();
    }
    $('#registration_certificate_img').hide();
    if(row.registration_certificate_img){
        $('#registration_certificate_img').attr('href',row.registration_certificate_img).show();
    }
    $('#vehicle_insurance_img').hide();
    if(row.vehicle_insurance_img){
        $('#vehicle_insurance_img').attr('href',row.vehicle_insurance_img).show();
    }

    $('#driving_licence_img').html('');
    if(row.driving_licence_img){
        var dl_img = '<ul class="unorder-list">';
        $.each(row.driving_licence_img, function( index, value ) {
            dl_img+='<li><a href="'+value+'" download>Download</a></li>';
        });
        dl_img+='</ul>';
        $('#driving_licence_img').html(dl_img);
    }
    $('#vehicle_photo_img').html('');
    if(row.vehicle_photo_img){
        var vp_img = '<ul class="unorder-list">';
        $.each(row.vehicle_photo_img, function( index, value ) {
            vp_img+='<li><a href="'+value+'" download>Download</a></li>';
        });
        vp_img+='</ul>';
        $('#vehicle_photo_img').html(vp_img);
    }

    var cnt = row.no_of_licence;
    var hiddenInput = $('<input>').attr({
      type: 'hidden',
      name: 'id',
      id: 'id',
      value: id
    });
    $('#myForm').append(hiddenInput);
    $('#myModel').modal('toggle');
});

$(document).on('click','.save',function(e){
    e.preventDefault();
    $('.parsley-validate').parsley().validate();
    if ($('.parsley-validate').parsley().isValid()){
        var postData = new FormData()
        postData = getFormValues(postData);
        $.ajax({
            type: 'POST',
            url:  "/<?= $TYPE ?>/driver/save",
            data: postData,
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            dataTyte: 'json',
            enctype: 'multipart/form-data',
            contentType: false,
            cache: false,
            processData:false,
            beforeSend: function() {
                 //$('.as_loader').addClass('show');
            },
            success: function(response){
                if(response.status == '1') {
                    table.ajax.reload();
                    $('#myModel').modal('toggle');
                    $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
                }else{
                    $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
                }
                //$('.as_loader').removeClass('show');
            },
            error: function (error) {
                //$('.as_loader').removeClass('show');
            }
        });
    }
});
</script>
@endsection
