<?php

use Illuminate\Support\Facades\Route;
use App\Http\Middleware\Admin\redirectAdminHome;
use App\Http\Middleware\Admin\redirectAdminLogin;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\DriverController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\LocationController;
use App\Http\Controllers\Admin\DiscountController;
use App\Http\Controllers\Admin\PackageController;
use App\Http\Controllers\Admin\TripController;
use App\Http\Controllers\Admin\WalletController;
use App\Http\Controllers\Admin\RatingController;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\DashboardController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

// Admin routes
Route::prefix('admin')->group(function () {
    Route::get('/', [AuthController::class, 'login'])->name('admin.login1');
    Route::get('/login', [AuthController::class, 'login'])->name('admin.login')->middleware(redirectAdminHome::class);
    Route::post('/login', [AuthController::class, 'login']);
    Route::get('/logout', [AuthController::class, 'logout']);

    Route::get('/dashboard', [DashboardController::class, 'index'])->name('admin.dashboard')->middleware(redirectAdminLogin::class);

    Route::get('/user', [UserController::class, 'index'])->name('admin.user')->middleware(redirectAdminLogin::class);
    Route::post('/user/index_ajax_user_list', [UserController::class, 'index_ajax_user_list'])->middleware(redirectAdminLogin::class);
    Route::post('/user/save', [UserController::class, 'save'])->middleware(redirectAdminLogin::class);
    Route::post('/user/disable', [UserController::class, 'disable'])->middleware(redirectAdminLogin::class);
    Route::post('/user/enable', [UserController::class, 'enable'])->middleware(redirectAdminLogin::class);

    Route::get('/driver', [DriverController::class, 'index'])->name('admin.driver')->middleware(redirectAdminLogin::class);
    Route::post('/driver/index_ajax_driver_list', [DriverController::class, 'index_ajax_driver_list'])->middleware(redirectAdminLogin::class);
    Route::post('/driver/save', [DriverController::class, 'save'])->middleware(redirectAdminLogin::class);
    Route::post('/driver/disable', [DriverController::class, 'disable'])->middleware(redirectAdminLogin::class);
    Route::post('/driver/enable', [DriverController::class, 'enable'])->middleware(redirectAdminLogin::class);


    Route::get('/category', [CategoryController::class, 'index'])->name('admin.category')->middleware(redirectAdminLogin::class);
    Route::post('/category/index_ajax_category_list', [CategoryController::class, 'index_ajax_category_list'])->middleware(redirectAdminLogin::class);
    Route::post('/category/save', [CategoryController::class, 'save'])->middleware(redirectAdminLogin::class);
    Route::post('/category/disable', [CategoryController::class, 'disable'])->middleware(redirectAdminLogin::class);
    Route::post('/category/enable', [CategoryController::class, 'enable'])->middleware(redirectAdminLogin::class);

    Route::get('/location', [LocationController::class, 'index'])->name('admin.location')->middleware(redirectAdminLogin::class);
    Route::post('/location/index_ajax_location_list', [LocationController::class, 'index_ajax_location_list'])->middleware(redirectAdminLogin::class);
    Route::post('/location/save', [LocationController::class, 'save'])->middleware(redirectAdminLogin::class);

    Route::get('/discount', [DiscountController::class, 'index'])->name('admin.discount')->middleware(redirectAdminLogin::class);
    Route::post('/discount/index_ajax_discount_list', [DiscountController::class, 'index_ajax_discount_list'])->middleware(redirectAdminLogin::class);
    Route::post('/discount/save', [DiscountController::class, 'save'])->middleware(redirectAdminLogin::class);
    Route::post('/discount/disable', [DiscountController::class, 'disable'])->middleware(redirectAdminLogin::class);
    Route::post('/discount/enable', [DiscountController::class, 'enable'])->middleware(redirectAdminLogin::class);

    Route::get('/package', [PackageController::class, 'index'])->name('admin.package')->middleware(redirectAdminLogin::class);
    Route::post('/package/index_ajax_package_list', [PackageController::class, 'index_ajax_package_list'])->middleware(redirectAdminLogin::class);
    Route::post('/package/save', [PackageController::class, 'save'])->middleware(redirectAdminLogin::class);

    Route::get('/trip', [TripController::class, 'index'])->name('admin.trip')->middleware(redirectAdminLogin::class);
    Route::post('/trip/index_ajax_trip_list', [TripController::class, 'index_ajax_trip_list'])->middleware(redirectAdminLogin::class);
    Route::post('/trip/save', [TripController::class, 'save'])->middleware(redirectAdminLogin::class);

    Route::get('/wallet', [WalletController::class, 'index'])->name('admin.wallet')->middleware(redirectAdminLogin::class);
    Route::post('/wallet/index_ajax_wallet_list', [WalletController::class, 'index_ajax_wallet_list'])->middleware(redirectAdminLogin::class);
    Route::post('/wallet/save', [WalletController::class, 'save'])->middleware(redirectAdminLogin::class);

    Route::get('/rating', [RatingController::class, 'index'])->name('admin.rating')->middleware(redirectAdminLogin::class);
    Route::post('/rating/index_ajax_rating_list', [RatingController::class, 'index_ajax_rating_list'])->middleware(redirectAdminLogin::class);
    Route::post('/rating/save', [RatingController::class, 'save'])->middleware(redirectAdminLogin::class);
});
